<?php
/**
 * PhotoAid - Send final photos via email
 * Retrieves from temp and sends unwatermarked versions
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);
header('Content-Type: application/json');

try {
    require_once __DIR__ . '/../includes/config.php';
    require_once __DIR__ . '/../includes/EmailService.php';
    
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('POST required');
    }
    
    $sessionId = $_POST['session_id'] ?? '';
    $email = filter_var($_POST['email'] ?? '', FILTER_VALIDATE_EMAIL);
    $plan = $_POST['plan'] ?? 'digital';
    
    if (!$sessionId) {
        throw new Exception('Invalid session');
    }
    
    if (!$email) {
        throw new Exception('Valid email required');
    }
    
    $tempDir = TEMP_DIR;
    $sessionFile = $tempDir . $sessionId . '_session.json';
    
    if (!file_exists($sessionFile)) {
        throw new Exception('Session expired. Please try again.');
    }
    
    $sessionData = json_decode(file_get_contents($sessionFile), true);
    
    if (!$sessionData) {
        throw new Exception('Invalid session data');
    }
    
    // Check if files exist
    $passportPath = $sessionData['passport_path'] ?? '';
    $sheetPath = $sessionData['sheet_path'] ?? '';
    
    if (!file_exists($passportPath) || !file_exists($sheetPath)) {
        throw new Exception('Photos expired. Please process again.');
    }
    
    // Send email with attachments
    $attachments = [
        $sessionData['spec_name'] . '_photo.jpg' => $passportPath,
        $sessionData['spec_name'] . '_print_sheet.jpg' => $sheetPath,
    ];
    
    $emailResult = EmailService::sendPhotos($email, $attachments, $sessionData['spec_name']);
    
    if (!$emailResult['success']) {
        throw new Exception('Email failed: ' . ($emailResult['error'] ?? 'Check configuration'));
    }
    
    // Cleanup - delete all session files after successful send
    $filesToDelete = glob($tempDir . $sessionId . '*');
    foreach ($filesToDelete as $file) {
        @unlink($file);
    }
    
    // Also delete preview
    $previewFile = __DIR__ . '/previews/' . $sessionId . '_preview.jpg';
    if (file_exists($previewFile)) {
        @unlink($previewFile);
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Photos sent to ' . $email
    ]);
    
} catch (Throwable $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
